(function ($) {
  "use strict";

  // Preloader
  $("#page").css("display", "none");
  $(window).on("load", function () {
    $("#loader").fadeOut(300);
    $("#page").show();
  });

  // Navbar
  $(window).on("scroll", function () {
    if ($(window).scrollTop() > 100) {
      $("header").addClass("navbar-scroll");
    } else {
      $("header").removeClass("navbar-scroll");
    }
  });

  // Copy IP Button
  document.getElementById("copyip").addEventListener("click", () => {
    navigator.clipboard.writeText("mc.koscraft.es").then((error) => {
      if (error) console.error(error);
      else
        Swal.fire({
          icon: "éxito",
          title: "Servidor IP Copiado",
          html: "El servidor IP se copió correctamente en el portapapeles.",
        });
    });
  });

  // Vote Switch
  let $frame = $(".voteFrame");

  $(".voteFrame").on("load", function () {
    $(".iframe-house").addClass("loaded");
  });

  $(".voteLink").click(function (e) {
    openVoteLink(this, e);
  });

  $(function () {
    openVoteLink($(".voteLink:first-child"));
  });

  function openVoteLink(el, e = null) {
    if (e && e.target.tagName === "A") return;
    if ($(el).hasClass("active")) return;
    $(".iframe-house").removeClass("loaded");
    let url = $(el).attr("data-url");
    $(".voteFrame").attr("src", url);
    $(".voteLink.active").removeClass("active");
    $(el).addClass("active");
  }
})(window.jQuery);
